/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRCustomPotion;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class LOTRPotionBleeding
extends LOTRCustomPotion {
    private static final int DEFAULT_DAMAGE_INTERVAL = 60;
    private static final int DEFAULT_DAMAGE_AMOUNT = 1;
    private static final double MOVEMENT_THRESHOLD = 0.005;
    private final Map<EntityLivingBase, Double[]> lastPositions = new HashMap<EntityLivingBase, Double[]>();
    private final Map<EntityLivingBase, Integer> jumpCooldowns = new HashMap<EntityLivingBase, Integer>();

    public LOTRPotionBleeding(int id, boolean isBadEffect, int potionColor, ResourceLocation tex, String namePot) {
        super(id, isBadEffect, potionColor, tex, namePot);
        this.func_76390_b("potion.lotr.bleeding");
        this.func_76399_b(0, 3);
        this.func_76404_a(1.0);
    }

    public boolean func_76397_a(int tick, int level) {
        int frequency = 60 >> level;
        return frequency > 0 && tick % frequency == 0;
    }

    private boolean isJumping(EntityLivingBase entity) {
        return entity.field_70181_x > 0.0 && !entity.field_70122_E && this.jumpCooldowns.compute(entity, (e, cooldown) -> cooldown == null || cooldown <= 0 ? 10 : cooldown - 1) == 10;
    }

    private boolean isMoving(EntityLivingBase entity) {
        Double[] lastPos = this.lastPositions.computeIfAbsent(entity, e -> new Double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v});
        double deltaX = Math.abs(entity.field_70165_t - lastPos[0]);
        double deltaY = Math.abs(entity.field_70163_u - lastPos[1]);
        double deltaZ = Math.abs(entity.field_70161_v - lastPos[2]);
        this.lastPositions.put(entity, new Double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v});
        return deltaX > 0.005 || deltaY > 0.005 || deltaZ > 0.005;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        World world = entity.field_70170_p;
        float currentHealth = entity.func_110143_aJ();
        float halfHeart = entity.func_110138_aP() / 10.0f;
        this.func_76390_b(this.getEffectName(amplifier + 1));
        if (currentHealth > halfHeart && currentHealth > 1.0f) {
            int damage = 1;
            if (entity instanceof EntityPlayer) {
                damage *= this.isJumping(entity) || entity.func_70051_ag() ? 2 : 1;
            }
            entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
            if (!world.field_72995_K) {
                LOTRPacketParticles packet = new LOTRPacketParticles("reddust", 10, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O / 2.0, entity.field_70161_v, 0.0, 0.1, 0.0);
                LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)entity, 64.0));
            } else {
                this.spawnClientParticles(world, entity, amplifier);
            }
        }
    }

    private void spawnClientParticles(World world, EntityLivingBase entity, int amplifier) {
        float[] color = this.getEffectColor(amplifier + 1);
        for (int i = 0; i < 20; ++i) {
            double d0 = entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d1 = entity.field_70163_u + world.field_73012_v.nextDouble() * (double)entity.field_70131_O * 1.5 - 0.25;
            double d2 = entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_72869_a("reddust", d0, d1, d2, (double)color[0], (double)color[1], (double)color[2]);
        }
    }

    private float[] getEffectColor(int level) {
        switch (level) {
            case 2: {
                return new float[]{0.5f, 0.0f, 0.0f};
            }
            case 3: {
                return new float[]{1.0f, 0.0f, 0.0f};
            }
        }
        return new float[]{0.8f, 0.0f, 0.0f};
    }

    private String getEffectName(int level) {
        switch (level) {
            case 1: {
                return "potion.lotr.bleeding.capillary";
            }
            case 2: {
                return "potion.lotr.bleeding.venous";
            }
            case 3: {
                return "potion.lotr.bleeding.arterial";
            }
        }
        return "potion.lotr.bleeding";
    }

    @Override
    public int func_76392_e() {
        return 0;
    }
}

